package demo.module;

import netsdk.lib.DeviceSdk;
import netsdk.lib.ErrorCodeAndConst;;

/**
 * 云台控制接口实现
 * 主要有 ：八个方向控制、变倍、变焦、光圈功能
 */
public class PtzControlModule {

	/**
	 * 向上
	 */
	public static boolean ptzControlUpStart(int nChannelID, int lParam1, int lParam2) {
		return LoginModule.netsdk.NET_SDK_PTZControl_Other(LoginModule.m_hLoginHandle, nChannelID, 
				ErrorCodeAndConst.NET_PTZ_UP_CONTROL, lParam2);
	}
	public static boolean ptzControlEnd(int nChannelID) {
		return LoginModule.netsdk.NET_SDK_PTZControl_Other(LoginModule.m_hLoginHandle, nChannelID, 
									 ErrorCodeAndConst.PTZ_CMD_STOP, 0);
	}
	
	/**
	 * 向下
	 */
	public static boolean ptzControlDownStart(int nChannelID, int lParam1, int lParam2) {
		return LoginModule.netsdk.NET_SDK_PTZControl_Other(LoginModule.m_hLoginHandle, nChannelID, 
											ErrorCodeAndConst.NET_PTZ_DOWN_CONTROL, lParam2);
	}
	
	/**
	 * 向左
	 */
	public static boolean ptzControlLeftStart(int nChannelID, int lParam1, int lParam2) {
		return LoginModule.netsdk.NET_SDK_PTZControl_Other(LoginModule.m_hLoginHandle, nChannelID, 
											ErrorCodeAndConst.NET_PTZ_LEFT_CONTROL, lParam2);	
	}

	
	/**
	 * 向右
	 */
	public static boolean ptzControlRightStart(int nChannelID, int lParam1,int lParam2) {
		return LoginModule.netsdk.NET_SDK_PTZControl_Other(LoginModule.m_hLoginHandle, nChannelID, 
											ErrorCodeAndConst.NET_PTZ_RIGHT_CONTROL, lParam2);
	}

	
	/**
	 * 向左上
	 */
	public static boolean ptzControlLeftUpStart(int nChannelID, int lParam1, int lParam2) {
		return LoginModule.netsdk.NET_SDK_PTZControl_Other(LoginModule.m_hLoginHandle, nChannelID, 
											ErrorCodeAndConst.NET_EXTPTZ_LEFTTOP, lParam2);
	}

	
	/**
	 * 向右上
	 */
	public static boolean ptzControlRightUpStart(int nChannelID, int lParam1, int lParam2) {
		return LoginModule.netsdk.NET_SDK_PTZControl_Other(LoginModule.m_hLoginHandle, nChannelID, 
											ErrorCodeAndConst.NET_EXTPTZ_RIGHTTOP, lParam2);
	}

	/**
	 * 向左下
	 */
	public static boolean ptzControlLeftDownStart(int nChannelID, int lParam1, int lParam2) {
		return LoginModule.netsdk.NET_SDK_PTZControl_Other(LoginModule.m_hLoginHandle, nChannelID, 
													ErrorCodeAndConst.NET_EXTPTZ_LEFTDOWN, lParam2);
	}

	
	/**
	 * 向右下
	 */
	public static boolean ptzControlRightDownStart(int nChannelID, int lParam1, int lParam2) {
		return LoginModule.netsdk.NET_SDK_PTZControl_Other(LoginModule.m_hLoginHandle, nChannelID, 
													ErrorCodeAndConst.NET_EXTPTZ_RIGHTDOWN, lParam2);
	}

	
    /**
     * 变倍+
     */
    public static boolean ptzControlZoomAddStart(int nChannelID, int lParam2) {
        return LoginModule.netsdk.NET_SDK_PTZControl_Other(LoginModule.m_hLoginHandle, nChannelID, 
							        	   ErrorCodeAndConst.NET_PTZ_ZOOM_ADD_CONTROL, lParam2);
    }


    /**
     * 变倍-
     */
    public static boolean ptzControlZoomDecStart(int nChannelID, int lParam2) {
       return LoginModule.netsdk.NET_SDK_PTZControl_Other(LoginModule.m_hLoginHandle, nChannelID, 
							        	    ErrorCodeAndConst.NET_PTZ_ZOOM_DEC_CONTROL, lParam2);
    }

    /**
     * 变焦+
     */
    public static boolean ptzControlFocusAddStart(int nChannelID, int lParam2) {
    	return LoginModule.netsdk.NET_SDK_PTZControl_Other(LoginModule.m_hLoginHandle, nChannelID, 
									        	    ErrorCodeAndConst.NET_PTZ_FOCUS_ADD_CONTROL, lParam2);
    }

    /**
     * 变焦-
     */
    public static boolean ptzControlFocusDecStart(int nChannelID, int lParam2) {
        return LoginModule.netsdk.NET_SDK_PTZControl_Other(LoginModule.m_hLoginHandle, nChannelID, 
							        	    ErrorCodeAndConst.NET_PTZ_FOCUS_DEC_CONTROL, lParam2);
    }

    /**
     * 光圈+
     */
    public static boolean ptzControlIrisAddStart(int nChannelID, int lParam2) {
        return LoginModule.netsdk.NET_SDK_PTZControl_Other(LoginModule.m_hLoginHandle, nChannelID, 
							        	    ErrorCodeAndConst.NET_PTZ_APERTURE_ADD_CONTROL, lParam2);
    }

    /**
     * 光圈-
     */
    public static boolean ptzControlIrisDecStart(int nChannelID, int lParam2) {
        return LoginModule.netsdk.NET_SDK_PTZControl_Other(LoginModule.m_hLoginHandle, nChannelID, 
									        	    ErrorCodeAndConst.NET_PTZ_APERTURE_DEC_CONTROL, lParam2);
    }

}
